## Example Summary

Example that uses the GPIO and UART driver to program an MSP430 FRAM based device.

## Peripherals Exercised

* `Board_GPIO_LED0` - Indicates that the board was initialized within `main()`
* `Board_UART0` - Used to show the progress of the BSL programming from host serial session
* `Board_UART1` - Used to send BSL commands to the target MSP430 device
* `Board_RESET_PIN` - Used to control the reset pin of the target MSP430 device
* `Board_TEST_PIN` - Used to control the test pin of the target MSP430 device

## Resources & Jumper Settings

> If you're using an IDE (such as CCS or IAR), please refer to Board.html in your project
directory for resources used and board-specific jumper settings. Otherwise, you can find
Board.html in the directory &lt;SDK_INSTALL_DIR&gt;/source/ti/boards/&lt;BOARD&gt;.


## Example Usage

* Open a serial session (e.g. [`PuTTY`](http://www.putty.org/ "PuTTY's Homepage"), etc.) to the appropriate COM port.
    * The COM port can be determined via Device Manager in Windows or via `ls /dev/tty*` in Linux.

The connection should have the following settings
```
    Baud-rate:	  9600
    Data bits:       8
    Stop bits:       1
    Parity:       None
    Flow Control: None
```

* Connect the Board_RESET_PIN (P03) to the reset pin of the target device (MSP430FR2311 rst pin used for testing)
* Connect the Board_TEST_PIN (P04) to the test pin of the target device (MSP430FR2311 test pin used for testing)
* Connect the Board_UART1 RX pin(P08) to the BSL Transmit pin of the target device (MSP430FR2311 P1.7 pin used for testing)
* Connect the Board_UART1 TX pin(P07) to the BSL Receive pin of the target device (MSP430FR2311 P1.6 pin used for testing)

* Run the example. `Board_GPIO_LED0` turns ON to indicate driver
initialization is complete.

* The CC32xx Host begins to program the target MSP430FR with the blinky image. The target MSP430 image is located in image/msp430fr_image.h

TI-RTOS:

* When building in Code Composer Studio, the kernel configuration project will be imported along with the example. The kernel configuration project is referenced by the example, so it will be built first. The "release" kernel configuration is the default project used. It has many debug features disabled. These feature include assert checking, logging and runtime stack checks. For a detailed difference between the "release" and "debug" kernel configurations and how to switch between them, please refer to the SimpleLink MCU SDK User's Guide. The "release" and "debug" kernel configuration projects can be found under &lt;SDK_INSTALL_DIR&gt;/kernel/tirtos/builds/&lt;BOARD&gt;/(release|debug)/(ccs|gcc).
